
//------------------------------------------------------------------------------
// To Study the Routh-Hurwitz Criterion 
//------------------------------------------------------------------------------

// OS : Windows 7
// Scilab : 6.0.1

clc;
clear all;

D=input('Input coefficients of characteristic equation,i.e:[a0 an+1 an+2_ _ _ _ _an]= ');
//Case- 1 enter cvalue of D = [1 2 8 4 3]
//Case- 2 enter cvalue of D = [1 1 3 6 6]
l=length (D);
 
disp('Roots of characteristic equation are=')
roots(D)
if modulo(l,2)= =0
    m=zeros(l,l/2);
    [cols,rows]=size(m);
    for i=1:rows
        m(1,i)=det(1,(2*i)-1);
        m(2,i)=det(1,(2*i));
    end
else
    m=zeros(l,(l+1)/2);
    [cols,rows]=size(m);
    for i=1:rows
        m(1,i)=D(1,(2*i)-1);
    end
    for i=1:((l-1)/2)
        m(2,i)=D(1,(2*i));
    end
end
 
for j=3:cols
    
    if m(j-1,1)==0
        m(j-1,1)=0.001;
    end
    
    for i=1:rows-1
        m(j,i)=(-1/m(j-1,1))*det([m(j-2,1) m(j-2,i+1);m(j-1,1) m(j-1,i+1)]);
    end
end
 
disp('--------The Routh-Hurwitz array is=--------', m)
//--------------------End of Bulding array--------------------------------
  
//Checking for sign change
Temp=sign(m);a=0;
for j=1:cols
    a=a+Temp(j,1);
end
if a==cols
    disp('          ----> Sign Not Changed in first Column so System is Stable <----')
else
    disp('          ----> Sign  Changed in first Column so System is Unstable <----')
end

